--[[
This is an example of a working clock. It shows how to do the following:

* Call a _frame #x# file
* Name objects so they can be called upon later
* Create a function to be set as the UpdateFunction
* Get a child from an ActorFrame
* Use string.format
* Set an UpdateFunction
]]

local t = Def.ActorFrame{
	-- background.
	LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded blackinset normal", 128, 32)..{
		Name="BGFrame";
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y);
	};
	-- clock.
	LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="Clock";
		InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;diffuse,color("#FFFFFF");shadowlength,1);
	};
};

local function Update(self)
	local clock = self:GetChild("Clock");
	
	local hour = Hour();
	local min = Minute();
	local sec = Second();
	
	-- A good guide to using string.format is here:
	-- http://www.cplusplus.com/reference/clibrary/cstdio/printf.html
	-- Don't be put off by the fact that it's geared towards C/C++,
	-- the basics are pretty much the same.
	
	-- Watch out for caveats with Lua though:
	-- http://www.lua.org/manual/5.1/manual.html#pdf-string.format
	
	-- In this example, we have %02i. Breaking this down gives us:
	-- % - begin
	-- 0 - a flag, stating that space should be padded with 0.
	-- 2 - the width, meaning two of whatever comes next.
	-- i - the type specifier, in this case an integer.
	clock:settext( string.format( '%02i:%02i:%02i', hour, min, sec ) );
end;

t.InitCommand=cmd(SetUpdateFunction,Update);

return t;